<?xml version="1.0"?>
<!-- Written by Peter Mertens "peter@pmertens.de" -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template match="/Depotbestand">
		<xsl:apply-templates select="Bestand"/>
	</xsl:template>
	<xsl:template match="Bestand">
		<tr>
			<td valign="top">
				<xsl:value-of select="Papiertyp"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Kennnummer"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Bezeichnung"/>
			</td>
			<xsl:choose>
				<xsl:when test='Stueckzahl!=""'>
					<td valign="top">
						<xsl:value-of select="format-number(Stueckzahl,'##,##0')"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td valign="top"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test='Nennwert!=""'>
					<td valign="top">
						<xsl:value-of select="format-number(Nennwert,'##,##0.##')"/>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td valign="top"/>
				</xsl:otherwise>
			</xsl:choose>
			<td valign="top">
				<xsl:value-of select="format-number(Kurs,'##,##0.00')"/>
			</td>
			<td valign="top">
				<xsl:value-of select="Waehrung"/>
			</td>
			<td valign="top">
				<xsl:value-of select="format-number(Wert,'##,##0.00')"/>
			</td>
			<xsl:if test='Papiertyp="Rentenpapier"'>
				<td valign="top">
					<xsl:value-of select="format-number(Zinsfluss,'##,##0.00')"/>
				</td>
			</xsl:if>
		</tr>
		<xsl:if test="position()=last()">
			<tr>
				<td valign="top">
					<font color="#FF0000">akumulierte</font>
				</td>
				<td valign="top">
					<font color="#FF0000">Jahreswerte:</font>
				</td>
				<td valign="top"/>
				<td valign="top"/>
				<td valign="top"/>
				<td valign="top"/>
				<td valign="top">
					<xsl:value-of select="Waehrung"/>
				</td>
				<td valign="top">
					<font color="#FF0000">
						<xsl:value-of select="format-number(sum(../Bestand/Wert),'##,##0.00')"/>
					</font>
				</td>
				<td valign="top">
					<font color="#FF0000">
						<xsl:value-of select="format-number(sum(../Bestand[Papiertyp='Rentenpapier']/Zinsfluss),'##,##0.00')"/>
					</font>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
